/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBUtils				= Object.create(STBModule.prototype);
	STBUtils.name			= "Utils";
	STBUtils.scripts		= [];

STBUtils.freezeBrowser = function() {
	if (site.onepage) {
		return false;
	}

	var pos = $(window).scrollTop();

	if ($("body").hasClass("sticky")){
		$("body").addClass("had-sticky");
	}

	$("body").addClass("frozen").attr("data-scrolled", pos);
	$("body").css("top", -pos);
	$("body").css("left", 0);

	if ($("body").hasClass("top-menu")){
		if ($("body .topintro").length) {
			var height =  $("body .topintro").height();

			if (pos < height) {
				pos = 0;
			} else {
				pos = pos - $("body .topintro").height();
			}
		}
		$("header").css("top", pos);
	}



	if ($("body").hasClass("had-sticky")) {
		var	
			$header				= $('.header'),
			$mainNav			= $(".main-nav");

		if ($mainNav.attr("data-bgs") != ""){
			$mainNav.removeClass($mainNav.attr("data-bg")).addClass($mainNav.attr("data-bgs"));
			$header.removeClass($header.attr("data-bg")).addClass($header.attr("data-bgs"));
		}
	}
}


STBUtils.unfreezeBrowser = function() {
	if (site.onepage) {
		return false;
	}


	if ($("body").hasClass("had-sticky")) {

		var	
			$header				= $('.header'),
			$mainNav			= $(".main-nav");

		//add the bgclass if exists
		if ($mainNav.attr("data-bg") != ""){
			$mainNav.removeClass($mainNav.attr("data-bgs")).addClass($mainNav.attr("data-bg"));
			$header.removeClass($header.attr("data-bgs")).addClass($header.attr("data-bg"));
		}

		$("body").removeClass("had-sticky");
	}

	$("body").removeClass("frozen");
	$("body").css("top", 0);

	$(window).scrollTop($("body").attr("data-scrolled"));

	if ($("body").hasClass("top-menu")){
		$("header").css("top", 0);
	}
}



STBUtils.momentConvertLocale = function(code) {
    try {
        var loc = {
            "ab": "",
            "aa": "",
            "af": "af",
            "sq": "sq",
            "am": "",
            "ar": "ar",
            "hy": "hy-am",
            "as": "",
            "ay": "",
            "az": "az",
            "ba": "",
            "eu": "eu",
            "bn": "bn",
            "dz": "",
            "bh": "",
            "bi": "",
            "br": "br",
            "bg": "bg",
            "my": "my",
            "be": "be",
            "km": "km",
            "ca": "ca",
            "zh": "zh-cn",
            "co": "",
            "hr": "hr",
            "cs": "cs",
            "da": "da",
            "nl": "nl",
            "en": "en_gb",
            "gb": "en_gb",
            "eo": "eo",
            "et": "et",
            "fo": "fo",
            "fj": "",
            "fi": "fi",
            "fr": "fr",
            "fy": "fy",
            "gd": "gd",
            "gl": "gl",
            "ka": "ka",
            "de": "de",
            "el": "el",
            "kl": "",
            "gn": "",
            "gu": "",
            "ha": "",
            "iw": "he",
            "he": "he",
            "hi": "hi",
            "hu": "hu",
            "is": "is",
            "in": "id",
            "ia": "",
            "ie": "",
            "ik": "",
            "ga": "",
            "it": "it",
            "ja": "ja",
            "jw": "jv",
            "kn": "",
            "ks": "",
            "kk": "kk",
            "rw": "",
            "ky": "ky",
            "rn": "",
            "ko": "ko",
            "ku": "",
            "lo": "lo",
            "la": "",
            "lv": "lv",
            "ln": "",
            "lt": "lt",
            "mk": "mk",
            "mg": "",
            "ms": "ms",
            "ml": "ml",
            "mt": "",
            "mi": "mi",
            "mr": "mr",
            "mo": "ro",
            "mn": "",
            "na": "",
            "ne": "ne",
            "no": "nb",
            "oc": "",
            "or": "",
            "om": "",
            "ps": "",
            "fa": "fa",
            "pl": "pl",
            "pt": "pt",
            "pa": "pa-in",
            "qu": "",
            "rm": "",
            "ro": "ro",
            "ru": "ru",
            "sm": "",
            "sg": "",
            "sa": "",
            "sr": "sr",
            "sh": "hr",
            "st": "",
            "tn": "",
            "sn": "",
            "sd": "",
            "si": "si",
            "ss": "ss",
            "sk": "sk",
            "sl": "sl",
            "so": "",
            "es": "es",
            "su": "",
            "sw": "sw",
            "sv": "sv",
            "tl": "tl-ph",
            "tg": "",
            "ta": "ta",
            "tt": "",
            "te": "te",
            "th": "th",
            "bo": "bo",
            "ti": "",
            "to": "",
            "ts": "",
            "tr": "tr",
            "tk": "",
            "tw": "",
            "uk": "uk",
            "ur": "",
            "uz": "uz",
            "vi": "vi",
            "vo": "",
            "cy": "cy",
            "wo": "",
            "xh": "",
            "ji": "",
            "yo": "",
            "zu": ""
        }, i, c;

        for (i in loc) {
            if (i == code) {

                if (loc[i]) {
                    c = loc[i];
                } else {
                    c = "en_gb";
                }

                return c;
            }
        }

    } catch (e) {
        getStack(0, e);
    }
}



STBUtils.bootstrapCols = function(items) {
    try {
        switch (items) {
            case "12":
                items = 1;
                break;
            case "6":
                items = 2;
                break;
            case "4":
                items = 3;
                break;
            case "3":
                items = 4;
                break;

            case "1-5":
                items = 5;
				break;

			case "2":
                items = 6;
                break;

            case "1-7":
                items = 7;
	            break;

            case "1":
                items = 12;
                break;
        }

        return items;

    } catch (e) {
        getStack(0, e);
    }
}



STBUtils.str_replace = function( r, w , s){
     return s.split(r).join(w);
}


STBUtils.isInView = function(elem) {
    var docViewTop = $(window).scrollTop();
    var docViewBottom = docViewTop + $(window).height();

    var elemTop = elem.offset().top;
    var elemBottom = elemTop + elem.height();

    return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
}


STBUtils.bgSchemeReplace = function(string, rep){
	try{
		var str_find = '{BG:SCHEME}';

		return string.replace( 
			new RegExp(str_find, "gi"), 
			rep 
		) ;      
	} catch(ex){
		return string;
	}
}


STBUtils.attrDefaultValue = function($data, $default) {
    try {
        var res;

        if (typeof $data === "undefined") {
            res = $default;
        } else {

			if ($data == ""){
				return $default;
			} else {
	            res = $data;
			}
        }

        return res;

    } catch (e) {
        getStack(0, e);
    }
}


STBUtils.loadScriptCallback = function(path , callback , execute) {

	//controls if the callback is executed everytime or only once when the script is loaded
	execute = execute || true;
	
	if ($.inArray(path , STBUtils.scripts) === -1) {
		STBUtils.scripts.push(path);

		$.getScript(
			path,
			function() {
				if (callback) {
					callback();
				}
			}
		);
	} else {

		if (execute && callback) {
			callback();
		}
	}
}


//custom add/remove css class
$.fn.extend({
  addUserClass: function(uclass) {
	  if (!$(this).hasClass(uclass)) {
		  $(this).addClass(uclass);
	  }
  },

  removeUserClass: function(uclass) {
	  if ($(this).hasClass(uclass)) {
		  $(this).removeClass(uclass);
	  }
  }
});


function goBack() {
    window.history.back();
}